/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DomainParameters;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class DSAParams
extends DomainParameters {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute subprime_;
    protected ByteArrayAttribute base_;
    protected LongAttribute primeBits_;

    public DSAParams() {
        this.keyType_.setLongValue(Key.KeyType.DSA);
    }

    protected DSAParams(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.DSA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.subprime_ = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.primeBits_ = new LongAttribute(Attribute.PRIME_BITS);
        DSAParams.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        DSAParams dSAParams = (DSAParams)super.clone();
        dSAParams.prime_ = (ByteArrayAttribute)this.prime_.clone();
        dSAParams.subprime_ = (ByteArrayAttribute)this.subprime_.clone();
        dSAParams.base_ = (ByteArrayAttribute)this.base_.clone();
        dSAParams.primeBits_ = (LongAttribute)this.primeBits_.clone();
        DSAParams.putAttributesInTable(dSAParams);
        return dSAParams;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof DSAParams) {
            DSAParams dSAParams = (DSAParams)object;
            bl = this == dSAParams || super.equals(dSAParams) && this.prime_.equals(dSAParams.prime_) && this.subprime_.equals(dSAParams.subprime_) && this.base_.equals(dSAParams.base_) && this.primeBits_.equals(dSAParams.primeBits_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new DSAParams(session, l);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public LongAttribute getPrimeBits() {
        return this.primeBits_;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime_;
    }

    protected static void putAttributesInTable(DSAParams dSAParams) {
        if (dSAParams == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        dSAParams.attributeTable_.put(Attribute.PRIME, dSAParams.prime_);
        dSAParams.attributeTable_.put(Attribute.SUBPRIME, dSAParams.subprime_);
        dSAParams.attributeTable_.put(Attribute.BASE, dSAParams.base_);
        dSAParams.attributeTable_.put(Attribute.PRIME_BITS, dSAParams.primeBits_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.prime_);
        Object.getAttributeValue(session, this.objectHandle_, this.subprime_);
        Object.getAttributeValue(session, this.objectHandle_, this.base_);
        Object.getAttributeValue(session, this.objectHandle_, this.primeBits_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subprime (hex): ");
        stringBuffer.append(this.subprime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime Bits (dec): ");
        stringBuffer.append(this.primeBits_.toString(10));
        return stringBuffer.toString();
    }
}

